/**
 * 
 */


import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import sun.misc.BASE64Decoder;

/**
 * @author romagnyg
 * 
 */
public class GrcDecoder {

	/**
	 * @param args
	 * @throws IOException
	 */
	public static void main(String[] args) throws IOException {

		BASE64Decoder decoder = new BASE64Decoder();
		
		 
		
		// ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/
		Pattern pBase64 = Pattern.compile("([A-Za-z0-9+/=])*");
		Pattern pHexa = Pattern.compile("([A-F0-9])*");

		File fIn = new File(args[1]);

		FileReader fr = new FileReader(fIn);
		BufferedReader br = new BufferedReader(fr);

		File fOut = new File(args[2]);
		FileOutputStream fw = new FileOutputStream(fOut);

		String line;

		while ((line = br.readLine()) != null) {

			// test the type of line read
			Matcher mHexa = pHexa.matcher(line);
			Matcher mBase64 = pBase64.matcher(line);
			
			if (mHexa.matches()) {

				fw.write(hexToByteArr(line));
				
			} else if (mBase64.matches()) {
				
				fw.write(decoder.decodeBuffer(line));
				
			}

		}
	}

	private static byte[] hexToByteArr(String hex) {

		byte[] bts = new byte[hex.length() / 2];
		for (int i = 0; i < bts.length; i++) {
			bts[i] = (byte) Integer.parseInt(hex.substring(i, i + 2), 16);
		}
		return bts;
	}
	
}
